/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.window;

import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.DensityKt;
import androidx.compose.ui.unit.LayoutDirection;
import androidx.compose.ui.window.Geometry_desktopKt;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0005H\u0000\"\u0014\u0010\u0000\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0001*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0018\u0010\b\u001a\u00020\t*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0018\u0010\u0004\u001a\u00020\u0001*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\r\"\u0014\u0010\u000e\u001a\u00020\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0018\u0010\u0012\u001a\u00020\u000f*\u00020\u00138@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u0018\u0010\u0012\u001a\u00020\u000f*\u00020\u00168@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0017\"\u0018\u0010\u0018\u001a\u00020\u0016*\u00020\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"GlobalDensity", "Landroidx/compose/ui/unit/Density;", "getGlobalDensity", "()Landroidx/compose/ui/unit/Density;", "density", "Ljava/awt/Component;", "getDensity", "(Ljava/awt/Component;)Landroidx/compose/ui/unit/Density;", "sizeInPx", "Landroidx/compose/ui/geometry/Size;", "getSizeInPx", "(Ljava/awt/Component;)J", "Ljava/awt/GraphicsConfiguration;", "(Ljava/awt/GraphicsConfiguration;)Landroidx/compose/ui/unit/Density;", "GlobalLayoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "getGlobalLayoutDirection", "()Landroidx/compose/ui/unit/LayoutDirection;", "layoutDirection", "Ljava/util/Locale;", "getLayoutDirection", "(Ljava/util/Locale;)Landroidx/compose/ui/unit/LayoutDirection;", "Ljava/awt/ComponentOrientation;", "(Ljava/awt/ComponentOrientation;)Landroidx/compose/ui/unit/LayoutDirection;", "componentOrientation", "getComponentOrientation", "(Landroidx/compose/ui/unit/LayoutDirection;)Ljava/awt/ComponentOrientation;", "layoutDirectionFor", "component", "ui"})
@SourceDebugExtension(value={"SMAP\nLayoutConfiguration.desktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayoutConfiguration.desktop.kt\nandroidx/compose/ui/window/LayoutConfiguration_desktopKt\n+ 2 Density.skiko.kt\nandroidx/compose/ui/unit/Density_skikoKt\n*L\n1#1,84:1\n79#2,3:85\n*S KotlinDebug\n*F\n+ 1 LayoutConfiguration.desktop.kt\nandroidx/compose/ui/window/LayoutConfiguration_desktopKt\n*L\n46#1:85,3\n*E\n"})
public final class LayoutConfiguration_desktopKt {
    @NotNull
    public static final Density getGlobalDensity() {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"getDefaultConfiguration(...)");
        return LayoutConfiguration_desktopKt.getDensity(graphicsConfiguration);
    }

    @NotNull
    public static final Density getDensity(@NotNull Component $this$density) {
        Intrinsics.checkNotNullParameter((Object)$this$density, (String)"<this>");
        GraphicsConfiguration graphicsConfiguration = $this$density.getGraphicsConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"getGraphicsConfiguration(...)");
        return LayoutConfiguration_desktopKt.getDensity(graphicsConfiguration);
    }

    /*
     * WARNING - void declaration
     */
    public static final long getSizeInPx(@NotNull Component $this$sizeInPx) {
        void $v$c$androidx-compose-ui-unit-DpSize$-$this$toSize$0$iv;
        Intrinsics.checkNotNullParameter((Object)$this$sizeInPx, (String)"<this>");
        Dimension dimension = $this$sizeInPx.getSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
        long l = Geometry_desktopKt.asDpSize(dimension);
        Density density$iv = LayoutConfiguration_desktopKt.getDensity($this$sizeInPx);
        boolean bl = false;
        Density $this$toSize_itqla9I_u24lambda_u240$iv = density$iv;
        boolean bl2 = false;
        return $this$toSize_itqla9I_u24lambda_u240$iv.toSize-XkaWNTQ((long)$v$c$androidx-compose-ui-unit-DpSize$-$this$toSize$0$iv);
    }

    private static final Density getDensity(GraphicsConfiguration $this$density) {
        return DensityKt.Density((float)$this$density.getDefaultTransform().getScaleX(), 1.0f);
    }

    @NotNull
    public static final LayoutDirection getGlobalLayoutDirection() {
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        return LayoutConfiguration_desktopKt.getLayoutDirection(locale);
    }

    @NotNull
    public static final LayoutDirection getLayoutDirection(@NotNull Locale $this$layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)$this$layoutDirection, (String)"<this>");
        ComponentOrientation componentOrientation = ComponentOrientation.getOrientation($this$layoutDirection);
        Intrinsics.checkNotNullExpressionValue((Object)componentOrientation, (String)"getOrientation(...)");
        return LayoutConfiguration_desktopKt.getLayoutDirection(componentOrientation);
    }

    @NotNull
    public static final LayoutDirection getLayoutDirection(@NotNull ComponentOrientation $this$layoutDirection) {
        Intrinsics.checkNotNullParameter((Object)$this$layoutDirection, (String)"<this>");
        return $this$layoutDirection.isLeftToRight() ? LayoutDirection.Ltr : ($this$layoutDirection.isHorizontal() ? LayoutDirection.Rtl : LayoutDirection.Ltr);
    }

    @NotNull
    public static final ComponentOrientation getComponentOrientation(@NotNull LayoutDirection $this$componentOrientation) {
        ComponentOrientation componentOrientation;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$componentOrientation), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$componentOrientation.ordinal()]) {
            case 1: {
                ComponentOrientation componentOrientation2 = ComponentOrientation.LEFT_TO_RIGHT;
                componentOrientation = componentOrientation2;
                Intrinsics.checkNotNullExpressionValue((Object)componentOrientation2, (String)"LEFT_TO_RIGHT");
                break;
            }
            case 2: {
                ComponentOrientation componentOrientation3 = ComponentOrientation.RIGHT_TO_LEFT;
                componentOrientation = componentOrientation3;
                Intrinsics.checkNotNullExpressionValue((Object)componentOrientation3, (String)"RIGHT_TO_LEFT");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return componentOrientation;
    }

    @NotNull
    public static final LayoutDirection layoutDirectionFor(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        ComponentOrientation orientation = component.getComponentOrientation();
        if (Intrinsics.areEqual((Object)orientation, (Object)ComponentOrientation.UNKNOWN)) {
            Locale locale = component.getLocale();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getLocale(...)");
            return LayoutConfiguration_desktopKt.getLayoutDirection(locale);
        }
        Intrinsics.checkNotNull((Object)orientation);
        return LayoutConfiguration_desktopKt.getLayoutDirection(orientation);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LayoutDirection.values().length];
            try {
                nArray[LayoutDirection.Ltr.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LayoutDirection.Rtl.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

