# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, Iterable, Optional, TypeVar

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models as _models
from .._serialization import Serializer

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_list_request(*, filter: Optional[str] = None, select: Optional[str] = None, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2015-04-01"))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/providers/Microsoft.Insights/eventtypes/management/values")

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")
    if filter is not None:
        _params["$filter"] = _SERIALIZER.query("filter", filter, "str")
    if select is not None:
        _params["$select"] = _SERIALIZER.query("select", select, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


class TenantActivityLogsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.monitor.MonitorManagementClient`'s
        :attr:`tenant_activity_logs` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(
        self, filter: Optional[str] = None, select: Optional[str] = None, **kwargs: Any
    ) -> Iterable["_models.EventData"]:
        """Gets the Activity Logs for the Tenant.\\ :code:`<br>`Everything that is applicable to the API
        to get the Activity Logs for the subscription is applicable to this API (the parameters,
        $filter, etc.).\\ :code:`<br>`One thing to point out here is that this API does *not* retrieve
        the logs at the individual subscription of the tenant but only surfaces the logs that were
        generated at the tenant level.

        :param filter: Reduces the set of data collected. :code:`<br>`The **$filter** is very
         restricted and allows only the following patterns.\\ :code:`<br>`- List events for a resource
         group: $filter=eventTimestamp ge '\\ :code:`<Start Time>`' and eventTimestamp le '\\
         :code:`<End Time>`' and eventChannels eq 'Admin, Operation' and resourceGroupName eq '\\
         :code:`<ResourceGroupName>`'.\\ :code:`<br>`- List events for resource: $filter=eventTimestamp
         ge '\\ :code:`<Start Time>`' and eventTimestamp le '\\ :code:`<End Time>`' and eventChannels eq
         'Admin, Operation' and resourceUri eq '\\ :code:`<ResourceURI>`'.\\ :code:`<br>`- List events
         for a subscription: $filter=eventTimestamp ge '\\ :code:`<Start Time>`' and eventTimestamp le
         '\\ :code:`<End Time>`' and eventChannels eq 'Admin, Operation'.\\ :code:`<br>`- List events
         for a resource provider: $filter=eventTimestamp ge '\\ :code:`<Start Time>`' and eventTimestamp
         le '\\ :code:`<End Time>`' and eventChannels eq 'Admin, Operation' and resourceProvider eq '\\
         :code:`<ResourceProviderName>`'.\\ :code:`<br>`- List events for a correlation Id:
         api-version=2014-04-01&$filter=eventTimestamp ge '2014-07-16T04:36:37.6407898Z' and
         eventTimestamp le '2014-07-20T04:36:37.6407898Z' and eventChannels eq 'Admin, Operation' and
         correlationId eq '\\ :code:`<CorrelationID>`'.\\ :code:`<br>`\\ **NOTE**\\ : No other syntax is
         allowed. Default value is None.
        :type filter: str
        :param select: Used to fetch events with only the given properties.\\ :code:`<br>`The
         **$select** argument is a comma separated list of property names to be returned. Possible
         values are: *authorization*\\ , *claims*\\ , *correlationId*\\ , *description*\\ ,
         *eventDataId*\\ , *eventName*\\ , *eventTimestamp*\\ , *httpRequest*\\ , *level*\\ ,
         *operationId*\\ , *operationName*\\ , *properties*\\ , *resourceGroupName*\\ ,
         *resourceProviderName*\\ , *resourceId*\\ , *status*\\ , *submissionTimestamp*\\ ,
         *subStatus*\\ , *subscriptionId*. Default value is None.
        :type select: str
        :return: An iterator like instance of either EventData or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.mgmt.monitor.models.EventData]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2015-04-01"))
        cls: ClsType[_models.EventDataCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_request(
                    filter=filter,
                    select=select,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("EventDataCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return ItemPaged(get_next, extract_data)
