# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Action(_serialization.Model):
    """The action that will be executed.

    :ivar action_type: The type of the action. Known values are: "EmailContacts" and "AutoRenew".
    :vartype action_type: str or ~azure.keyvault.v7_1.models.ActionType
    """

    _attribute_map = {
        "action_type": {"key": "action_type", "type": "str"},
    }

    def __init__(self, *, action_type: Optional[Union[str, "_models.ActionType"]] = None, **kwargs: Any) -> None:
        """
        :keyword action_type: The type of the action. Known values are: "EmailContacts" and
         "AutoRenew".
        :paramtype action_type: str or ~azure.keyvault.v7_1.models.ActionType
        """
        super().__init__(**kwargs)
        self.action_type = action_type


class AdministratorDetails(_serialization.Model):
    """Details of the organization administrator of the certificate issuer.

    :ivar first_name: First name.
    :vartype first_name: str
    :ivar last_name: Last name.
    :vartype last_name: str
    :ivar email_address: Email address.
    :vartype email_address: str
    :ivar phone: Phone number.
    :vartype phone: str
    """

    _attribute_map = {
        "first_name": {"key": "first_name", "type": "str"},
        "last_name": {"key": "last_name", "type": "str"},
        "email_address": {"key": "email", "type": "str"},
        "phone": {"key": "phone", "type": "str"},
    }

    def __init__(
        self,
        *,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        email_address: Optional[str] = None,
        phone: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword first_name: First name.
        :paramtype first_name: str
        :keyword last_name: Last name.
        :paramtype last_name: str
        :keyword email_address: Email address.
        :paramtype email_address: str
        :keyword phone: Phone number.
        :paramtype phone: str
        """
        super().__init__(**kwargs)
        self.first_name = first_name
        self.last_name = last_name
        self.email_address = email_address
        self.phone = phone


class Attributes(_serialization.Model):
    """The object attributes managed by the KeyVault service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar enabled: Determines whether the object is enabled.
    :vartype enabled: bool
    :ivar not_before: Not before date in UTC.
    :vartype not_before: ~datetime.datetime
    :ivar expires: Expiry date in UTC.
    :vartype expires: ~datetime.datetime
    :ivar created: Creation time in UTC.
    :vartype created: ~datetime.datetime
    :ivar updated: Last updated time in UTC.
    :vartype updated: ~datetime.datetime
    """

    _validation = {
        "created": {"readonly": True},
        "updated": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "not_before": {"key": "nbf", "type": "unix-time"},
        "expires": {"key": "exp", "type": "unix-time"},
        "created": {"key": "created", "type": "unix-time"},
        "updated": {"key": "updated", "type": "unix-time"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        not_before: Optional[datetime.datetime] = None,
        expires: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Determines whether the object is enabled.
        :paramtype enabled: bool
        :keyword not_before: Not before date in UTC.
        :paramtype not_before: ~datetime.datetime
        :keyword expires: Expiry date in UTC.
        :paramtype expires: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.not_before = not_before
        self.expires = expires
        self.created = None
        self.updated = None


class BackupCertificateResult(_serialization.Model):
    """The backup certificate result, containing the backup blob.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The backup blob containing the backed up certificate.
    :vartype value: bytes
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "base64"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class CertificateAttributes(Attributes):
    """The certificate management attributes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar enabled: Determines whether the object is enabled.
    :vartype enabled: bool
    :ivar not_before: Not before date in UTC.
    :vartype not_before: ~datetime.datetime
    :ivar expires: Expiry date in UTC.
    :vartype expires: ~datetime.datetime
    :ivar created: Creation time in UTC.
    :vartype created: ~datetime.datetime
    :ivar updated: Last updated time in UTC.
    :vartype updated: ~datetime.datetime
    :ivar recoverable_days: softDelete data retention days. Value should be >=7 and <=90 when
     softDelete enabled, otherwise 0.
    :vartype recoverable_days: int
    :ivar recovery_level: Reflects the deletion recovery level currently in effect for certificates
     in the current vault. If it contains 'Purgeable', the certificate can be permanently deleted by
     a privileged user; otherwise, only the system can purge the certificate, at the end of the
     retention interval. Known values are: "Purgeable", "Recoverable+Purgeable", "Recoverable",
     "Recoverable+ProtectedSubscription", "CustomizedRecoverable+Purgeable",
     "CustomizedRecoverable", and "CustomizedRecoverable+ProtectedSubscription".
    :vartype recovery_level: str or ~azure.keyvault.v7_1.models.DeletionRecoveryLevel
    """

    _validation = {
        "created": {"readonly": True},
        "updated": {"readonly": True},
        "recoverable_days": {"readonly": True},
        "recovery_level": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "not_before": {"key": "nbf", "type": "unix-time"},
        "expires": {"key": "exp", "type": "unix-time"},
        "created": {"key": "created", "type": "unix-time"},
        "updated": {"key": "updated", "type": "unix-time"},
        "recoverable_days": {"key": "recoverableDays", "type": "int"},
        "recovery_level": {"key": "recoveryLevel", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        not_before: Optional[datetime.datetime] = None,
        expires: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Determines whether the object is enabled.
        :paramtype enabled: bool
        :keyword not_before: Not before date in UTC.
        :paramtype not_before: ~datetime.datetime
        :keyword expires: Expiry date in UTC.
        :paramtype expires: ~datetime.datetime
        """
        super().__init__(enabled=enabled, not_before=not_before, expires=expires, **kwargs)
        self.recoverable_days = None
        self.recovery_level = None


class CertificateBundle(_serialization.Model):
    """A certificate bundle consists of a certificate (X509) plus its attributes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The certificate id.
    :vartype id: str
    :ivar kid: The key id.
    :vartype kid: str
    :ivar sid: The secret id.
    :vartype sid: str
    :ivar x509_thumbprint: Thumbprint of the certificate.
    :vartype x509_thumbprint: bytes
    :ivar policy: The management policy.
    :vartype policy: ~azure.keyvault.v7_1.models.CertificatePolicy
    :ivar cer: CER contents of x509 certificate.
    :vartype cer: bytes
    :ivar content_type: The content type of the secret.
    :vartype content_type: str
    :ivar attributes: The certificate attributes.
    :vartype attributes: ~azure.keyvault.v7_1.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "kid": {"readonly": True},
        "sid": {"readonly": True},
        "x509_thumbprint": {"readonly": True},
        "policy": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "kid": {"key": "kid", "type": "str"},
        "sid": {"key": "sid", "type": "str"},
        "x509_thumbprint": {"key": "x5t", "type": "base64"},
        "policy": {"key": "policy", "type": "CertificatePolicy"},
        "cer": {"key": "cer", "type": "bytearray"},
        "content_type": {"key": "contentType", "type": "str"},
        "attributes": {"key": "attributes", "type": "CertificateAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        cer: Optional[bytes] = None,
        content_type: Optional[str] = None,
        attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cer: CER contents of x509 certificate.
        :paramtype cer: bytes
        :keyword content_type: The content type of the secret.
        :paramtype content_type: str
        :keyword attributes: The certificate attributes.
        :paramtype attributes: ~azure.keyvault.v7_1.models.CertificateAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.kid = None
        self.sid = None
        self.x509_thumbprint = None
        self.policy = None
        self.cer = cer
        self.content_type = content_type
        self.attributes = attributes
        self.tags = tags


class CertificateCreateParameters(_serialization.Model):
    """The certificate create parameters.

    :ivar certificate_policy: The management policy for the certificate.
    :vartype certificate_policy: ~azure.keyvault.v7_1.models.CertificatePolicy
    :ivar certificate_attributes: The attributes of the certificate (optional).
    :vartype certificate_attributes: ~azure.keyvault.v7_1.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "certificate_policy": {"key": "policy", "type": "CertificatePolicy"},
        "certificate_attributes": {"key": "attributes", "type": "CertificateAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        certificate_policy: Optional["_models.CertificatePolicy"] = None,
        certificate_attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword certificate_policy: The management policy for the certificate.
        :paramtype certificate_policy: ~azure.keyvault.v7_1.models.CertificatePolicy
        :keyword certificate_attributes: The attributes of the certificate (optional).
        :paramtype certificate_attributes: ~azure.keyvault.v7_1.models.CertificateAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.certificate_policy = certificate_policy
        self.certificate_attributes = certificate_attributes
        self.tags = tags


class CertificateImportParameters(_serialization.Model):
    """The certificate import parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar base64_encoded_certificate: A PEM file or a base64-encoded PFX file.  PEM files need to
     contain the private key. Required.
    :vartype base64_encoded_certificate: str
    :ivar password: If the private key in base64EncodedCertificate is encrypted, the password used
     for encryption.
    :vartype password: str
    :ivar certificate_policy: The management policy for the certificate.
    :vartype certificate_policy: ~azure.keyvault.v7_1.models.CertificatePolicy
    :ivar certificate_attributes: The attributes of the certificate (optional).
    :vartype certificate_attributes: ~azure.keyvault.v7_1.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "base64_encoded_certificate": {"required": True},
    }

    _attribute_map = {
        "base64_encoded_certificate": {"key": "value", "type": "str"},
        "password": {"key": "pwd", "type": "str"},
        "certificate_policy": {"key": "policy", "type": "CertificatePolicy"},
        "certificate_attributes": {"key": "attributes", "type": "CertificateAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        base64_encoded_certificate: str,
        password: Optional[str] = None,
        certificate_policy: Optional["_models.CertificatePolicy"] = None,
        certificate_attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword base64_encoded_certificate: A PEM file or a base64-encoded PFX file.  PEM files need
         to contain the private key. Required.
        :paramtype base64_encoded_certificate: str
        :keyword password: If the private key in base64EncodedCertificate is encrypted, the password
         used for encryption.
        :paramtype password: str
        :keyword certificate_policy: The management policy for the certificate.
        :paramtype certificate_policy: ~azure.keyvault.v7_1.models.CertificatePolicy
        :keyword certificate_attributes: The attributes of the certificate (optional).
        :paramtype certificate_attributes: ~azure.keyvault.v7_1.models.CertificateAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.base64_encoded_certificate = base64_encoded_certificate
        self.password = password
        self.certificate_policy = certificate_policy
        self.certificate_attributes = certificate_attributes
        self.tags = tags


class CertificateIssuerItem(_serialization.Model):
    """The certificate issuer item containing certificate issuer metadata.

    :ivar id: Certificate Identifier.
    :vartype id: str
    :ivar provider: The issuer provider.
    :vartype provider: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "provider": {"key": "provider", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        provider: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Certificate Identifier.
        :paramtype id: str
        :keyword provider: The issuer provider.
        :paramtype provider: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.provider = provider


class CertificateIssuerListResult(_serialization.Model):
    """The certificate issuer list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A response message containing a list of certificate issuers in the key vault along
     with a link to the next page of certificate issuers.
    :vartype value: list[~azure.keyvault.v7_1.models.CertificateIssuerItem]
    :ivar next_link: The URL to get the next set of certificate issuers.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CertificateIssuerItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class CertificateIssuerSetParameters(_serialization.Model):
    """The certificate issuer set parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar provider: The issuer provider. Required.
    :vartype provider: str
    :ivar credentials: The credentials to be used for the issuer.
    :vartype credentials: ~azure.keyvault.v7_1.models.IssuerCredentials
    :ivar organization_details: Details of the organization as provided to the issuer.
    :vartype organization_details: ~azure.keyvault.v7_1.models.OrganizationDetails
    :ivar attributes: Attributes of the issuer object.
    :vartype attributes: ~azure.keyvault.v7_1.models.IssuerAttributes
    """

    _validation = {
        "provider": {"required": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "credentials": {"key": "credentials", "type": "IssuerCredentials"},
        "organization_details": {"key": "org_details", "type": "OrganizationDetails"},
        "attributes": {"key": "attributes", "type": "IssuerAttributes"},
    }

    def __init__(
        self,
        *,
        provider: str,
        credentials: Optional["_models.IssuerCredentials"] = None,
        organization_details: Optional["_models.OrganizationDetails"] = None,
        attributes: Optional["_models.IssuerAttributes"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: The issuer provider. Required.
        :paramtype provider: str
        :keyword credentials: The credentials to be used for the issuer.
        :paramtype credentials: ~azure.keyvault.v7_1.models.IssuerCredentials
        :keyword organization_details: Details of the organization as provided to the issuer.
        :paramtype organization_details: ~azure.keyvault.v7_1.models.OrganizationDetails
        :keyword attributes: Attributes of the issuer object.
        :paramtype attributes: ~azure.keyvault.v7_1.models.IssuerAttributes
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.credentials = credentials
        self.organization_details = organization_details
        self.attributes = attributes


class CertificateIssuerUpdateParameters(_serialization.Model):
    """The certificate issuer update parameters.

    :ivar provider: The issuer provider.
    :vartype provider: str
    :ivar credentials: The credentials to be used for the issuer.
    :vartype credentials: ~azure.keyvault.v7_1.models.IssuerCredentials
    :ivar organization_details: Details of the organization as provided to the issuer.
    :vartype organization_details: ~azure.keyvault.v7_1.models.OrganizationDetails
    :ivar attributes: Attributes of the issuer object.
    :vartype attributes: ~azure.keyvault.v7_1.models.IssuerAttributes
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "credentials": {"key": "credentials", "type": "IssuerCredentials"},
        "organization_details": {"key": "org_details", "type": "OrganizationDetails"},
        "attributes": {"key": "attributes", "type": "IssuerAttributes"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        credentials: Optional["_models.IssuerCredentials"] = None,
        organization_details: Optional["_models.OrganizationDetails"] = None,
        attributes: Optional["_models.IssuerAttributes"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: The issuer provider.
        :paramtype provider: str
        :keyword credentials: The credentials to be used for the issuer.
        :paramtype credentials: ~azure.keyvault.v7_1.models.IssuerCredentials
        :keyword organization_details: Details of the organization as provided to the issuer.
        :paramtype organization_details: ~azure.keyvault.v7_1.models.OrganizationDetails
        :keyword attributes: Attributes of the issuer object.
        :paramtype attributes: ~azure.keyvault.v7_1.models.IssuerAttributes
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.credentials = credentials
        self.organization_details = organization_details
        self.attributes = attributes


class CertificateItem(_serialization.Model):
    """The certificate item containing certificate metadata.

    :ivar id: Certificate identifier.
    :vartype id: str
    :ivar attributes: The certificate management attributes.
    :vartype attributes: ~azure.keyvault.v7_1.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar x509_thumbprint: Thumbprint of the certificate.
    :vartype x509_thumbprint: bytes
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "attributes": {"key": "attributes", "type": "CertificateAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
        "x509_thumbprint": {"key": "x5t", "type": "base64"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        x509_thumbprint: Optional[bytes] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Certificate identifier.
        :paramtype id: str
        :keyword attributes: The certificate management attributes.
        :paramtype attributes: ~azure.keyvault.v7_1.models.CertificateAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        :keyword x509_thumbprint: Thumbprint of the certificate.
        :paramtype x509_thumbprint: bytes
        """
        super().__init__(**kwargs)
        self.id = id
        self.attributes = attributes
        self.tags = tags
        self.x509_thumbprint = x509_thumbprint


class CertificateListResult(_serialization.Model):
    """The certificate list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A response message containing a list of certificates in the key vault along with a
     link to the next page of certificates.
    :vartype value: list[~azure.keyvault.v7_1.models.CertificateItem]
    :ivar next_link: The URL to get the next set of certificates.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CertificateItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class CertificateMergeParameters(_serialization.Model):
    """The certificate merge parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar x509_certificates: The certificate or the certificate chain to merge. Required.
    :vartype x509_certificates: list[bytes]
    :ivar certificate_attributes: The attributes of the certificate (optional).
    :vartype certificate_attributes: ~azure.keyvault.v7_1.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "x509_certificates": {"required": True},
    }

    _attribute_map = {
        "x509_certificates": {"key": "x5c", "type": "[bytearray]"},
        "certificate_attributes": {"key": "attributes", "type": "CertificateAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        x509_certificates: List[bytes],
        certificate_attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword x509_certificates: The certificate or the certificate chain to merge. Required.
        :paramtype x509_certificates: list[bytes]
        :keyword certificate_attributes: The attributes of the certificate (optional).
        :paramtype certificate_attributes: ~azure.keyvault.v7_1.models.CertificateAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.x509_certificates = x509_certificates
        self.certificate_attributes = certificate_attributes
        self.tags = tags


class CertificateOperation(_serialization.Model):
    """A certificate operation is returned in case of asynchronous requests.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The certificate id.
    :vartype id: str
    :ivar issuer_parameters: Parameters for the issuer of the X509 component of a certificate.
    :vartype issuer_parameters: ~azure.keyvault.v7_1.models.IssuerParameters
    :ivar csr: The certificate signing request (CSR) that is being used in the certificate
     operation.
    :vartype csr: bytes
    :ivar cancellation_requested: Indicates if cancellation was requested on the certificate
     operation.
    :vartype cancellation_requested: bool
    :ivar status: Status of the certificate operation.
    :vartype status: str
    :ivar status_details: The status details of the certificate operation.
    :vartype status_details: str
    :ivar error: Error encountered, if any, during the certificate operation.
    :vartype error: ~azure.keyvault.v7_1.models.Error
    :ivar target: Location which contains the result of the certificate operation.
    :vartype target: str
    :ivar request_id: Identifier for the certificate operation.
    :vartype request_id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "issuer_parameters": {"key": "issuer", "type": "IssuerParameters"},
        "csr": {"key": "csr", "type": "bytearray"},
        "cancellation_requested": {"key": "cancellation_requested", "type": "bool"},
        "status": {"key": "status", "type": "str"},
        "status_details": {"key": "status_details", "type": "str"},
        "error": {"key": "error", "type": "Error"},
        "target": {"key": "target", "type": "str"},
        "request_id": {"key": "request_id", "type": "str"},
    }

    def __init__(
        self,
        *,
        issuer_parameters: Optional["_models.IssuerParameters"] = None,
        csr: Optional[bytes] = None,
        cancellation_requested: Optional[bool] = None,
        status: Optional[str] = None,
        status_details: Optional[str] = None,
        error: Optional["_models.Error"] = None,
        target: Optional[str] = None,
        request_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword issuer_parameters: Parameters for the issuer of the X509 component of a certificate.
        :paramtype issuer_parameters: ~azure.keyvault.v7_1.models.IssuerParameters
        :keyword csr: The certificate signing request (CSR) that is being used in the certificate
         operation.
        :paramtype csr: bytes
        :keyword cancellation_requested: Indicates if cancellation was requested on the certificate
         operation.
        :paramtype cancellation_requested: bool
        :keyword status: Status of the certificate operation.
        :paramtype status: str
        :keyword status_details: The status details of the certificate operation.
        :paramtype status_details: str
        :keyword error: Error encountered, if any, during the certificate operation.
        :paramtype error: ~azure.keyvault.v7_1.models.Error
        :keyword target: Location which contains the result of the certificate operation.
        :paramtype target: str
        :keyword request_id: Identifier for the certificate operation.
        :paramtype request_id: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.issuer_parameters = issuer_parameters
        self.csr = csr
        self.cancellation_requested = cancellation_requested
        self.status = status
        self.status_details = status_details
        self.error = error
        self.target = target
        self.request_id = request_id


class CertificateOperationUpdateParameter(_serialization.Model):
    """The certificate operation update parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar cancellation_requested: Indicates if cancellation was requested on the certificate
     operation. Required.
    :vartype cancellation_requested: bool
    """

    _validation = {
        "cancellation_requested": {"required": True},
    }

    _attribute_map = {
        "cancellation_requested": {"key": "cancellation_requested", "type": "bool"},
    }

    def __init__(self, *, cancellation_requested: bool, **kwargs: Any) -> None:
        """
        :keyword cancellation_requested: Indicates if cancellation was requested on the certificate
         operation. Required.
        :paramtype cancellation_requested: bool
        """
        super().__init__(**kwargs)
        self.cancellation_requested = cancellation_requested


class CertificatePolicy(_serialization.Model):
    """Management policy for a certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The certificate id.
    :vartype id: str
    :ivar key_properties: Properties of the key backing a certificate.
    :vartype key_properties: ~azure.keyvault.v7_1.models.KeyProperties
    :ivar secret_properties: Properties of the secret backing a certificate.
    :vartype secret_properties: ~azure.keyvault.v7_1.models.SecretProperties
    :ivar x509_certificate_properties: Properties of the X509 component of a certificate.
    :vartype x509_certificate_properties: ~azure.keyvault.v7_1.models.X509CertificateProperties
    :ivar lifetime_actions: Actions that will be performed by Key Vault over the lifetime of a
     certificate.
    :vartype lifetime_actions: list[~azure.keyvault.v7_1.models.LifetimeAction]
    :ivar issuer_parameters: Parameters for the issuer of the X509 component of a certificate.
    :vartype issuer_parameters: ~azure.keyvault.v7_1.models.IssuerParameters
    :ivar attributes: The certificate attributes.
    :vartype attributes: ~azure.keyvault.v7_1.models.CertificateAttributes
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "key_properties": {"key": "key_props", "type": "KeyProperties"},
        "secret_properties": {"key": "secret_props", "type": "SecretProperties"},
        "x509_certificate_properties": {"key": "x509_props", "type": "X509CertificateProperties"},
        "lifetime_actions": {"key": "lifetime_actions", "type": "[LifetimeAction]"},
        "issuer_parameters": {"key": "issuer", "type": "IssuerParameters"},
        "attributes": {"key": "attributes", "type": "CertificateAttributes"},
    }

    def __init__(
        self,
        *,
        key_properties: Optional["_models.KeyProperties"] = None,
        secret_properties: Optional["_models.SecretProperties"] = None,
        x509_certificate_properties: Optional["_models.X509CertificateProperties"] = None,
        lifetime_actions: Optional[List["_models.LifetimeAction"]] = None,
        issuer_parameters: Optional["_models.IssuerParameters"] = None,
        attributes: Optional["_models.CertificateAttributes"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_properties: Properties of the key backing a certificate.
        :paramtype key_properties: ~azure.keyvault.v7_1.models.KeyProperties
        :keyword secret_properties: Properties of the secret backing a certificate.
        :paramtype secret_properties: ~azure.keyvault.v7_1.models.SecretProperties
        :keyword x509_certificate_properties: Properties of the X509 component of a certificate.
        :paramtype x509_certificate_properties: ~azure.keyvault.v7_1.models.X509CertificateProperties
        :keyword lifetime_actions: Actions that will be performed by Key Vault over the lifetime of a
         certificate.
        :paramtype lifetime_actions: list[~azure.keyvault.v7_1.models.LifetimeAction]
        :keyword issuer_parameters: Parameters for the issuer of the X509 component of a certificate.
        :paramtype issuer_parameters: ~azure.keyvault.v7_1.models.IssuerParameters
        :keyword attributes: The certificate attributes.
        :paramtype attributes: ~azure.keyvault.v7_1.models.CertificateAttributes
        """
        super().__init__(**kwargs)
        self.id = None
        self.key_properties = key_properties
        self.secret_properties = secret_properties
        self.x509_certificate_properties = x509_certificate_properties
        self.lifetime_actions = lifetime_actions
        self.issuer_parameters = issuer_parameters
        self.attributes = attributes


class CertificateRestoreParameters(_serialization.Model):
    """The certificate restore parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar certificate_bundle_backup: The backup blob associated with a certificate bundle.
     Required.
    :vartype certificate_bundle_backup: bytes
    """

    _validation = {
        "certificate_bundle_backup": {"required": True},
    }

    _attribute_map = {
        "certificate_bundle_backup": {"key": "value", "type": "base64"},
    }

    def __init__(self, *, certificate_bundle_backup: bytes, **kwargs: Any) -> None:
        """
        :keyword certificate_bundle_backup: The backup blob associated with a certificate bundle.
         Required.
        :paramtype certificate_bundle_backup: bytes
        """
        super().__init__(**kwargs)
        self.certificate_bundle_backup = certificate_bundle_backup


class CertificateUpdateParameters(_serialization.Model):
    """The certificate update parameters.

    :ivar certificate_policy: The management policy for the certificate.
    :vartype certificate_policy: ~azure.keyvault.v7_1.models.CertificatePolicy
    :ivar certificate_attributes: The attributes of the certificate (optional).
    :vartype certificate_attributes: ~azure.keyvault.v7_1.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "certificate_policy": {"key": "policy", "type": "CertificatePolicy"},
        "certificate_attributes": {"key": "attributes", "type": "CertificateAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        certificate_policy: Optional["_models.CertificatePolicy"] = None,
        certificate_attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword certificate_policy: The management policy for the certificate.
        :paramtype certificate_policy: ~azure.keyvault.v7_1.models.CertificatePolicy
        :keyword certificate_attributes: The attributes of the certificate (optional).
        :paramtype certificate_attributes: ~azure.keyvault.v7_1.models.CertificateAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.certificate_policy = certificate_policy
        self.certificate_attributes = certificate_attributes
        self.tags = tags


class Contact(_serialization.Model):
    """The contact information for the vault certificates.

    :ivar email_address: Email address.
    :vartype email_address: str
    :ivar name: Name.
    :vartype name: str
    :ivar phone: Phone number.
    :vartype phone: str
    """

    _attribute_map = {
        "email_address": {"key": "email", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "phone": {"key": "phone", "type": "str"},
    }

    def __init__(
        self,
        *,
        email_address: Optional[str] = None,
        name: Optional[str] = None,
        phone: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword email_address: Email address.
        :paramtype email_address: str
        :keyword name: Name.
        :paramtype name: str
        :keyword phone: Phone number.
        :paramtype phone: str
        """
        super().__init__(**kwargs)
        self.email_address = email_address
        self.name = name
        self.phone = phone


class Contacts(_serialization.Model):
    """The contacts for the vault certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Identifier for the contacts collection.
    :vartype id: str
    :ivar contact_list: The contact list for the vault certificates.
    :vartype contact_list: list[~azure.keyvault.v7_1.models.Contact]
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "contact_list": {"key": "contacts", "type": "[Contact]"},
    }

    def __init__(self, *, contact_list: Optional[List["_models.Contact"]] = None, **kwargs: Any) -> None:
        """
        :keyword contact_list: The contact list for the vault certificates.
        :paramtype contact_list: list[~azure.keyvault.v7_1.models.Contact]
        """
        super().__init__(**kwargs)
        self.id = None
        self.contact_list = contact_list


class DeletedCertificateBundle(CertificateBundle):  # pylint: disable=too-many-instance-attributes
    """A Deleted Certificate consisting of its previous id, attributes and its tags, as well as
    information on when it will be purged.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The certificate id.
    :vartype id: str
    :ivar kid: The key id.
    :vartype kid: str
    :ivar sid: The secret id.
    :vartype sid: str
    :ivar x509_thumbprint: Thumbprint of the certificate.
    :vartype x509_thumbprint: bytes
    :ivar policy: The management policy.
    :vartype policy: ~azure.keyvault.v7_1.models.CertificatePolicy
    :ivar cer: CER contents of x509 certificate.
    :vartype cer: bytes
    :ivar content_type: The content type of the secret.
    :vartype content_type: str
    :ivar attributes: The certificate attributes.
    :vartype attributes: ~azure.keyvault.v7_1.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar recovery_id: The url of the recovery object, used to identify and recover the deleted
     certificate.
    :vartype recovery_id: str
    :ivar scheduled_purge_date: The time when the certificate is scheduled to be purged, in UTC.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar deleted_date: The time when the certificate was deleted, in UTC.
    :vartype deleted_date: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "kid": {"readonly": True},
        "sid": {"readonly": True},
        "x509_thumbprint": {"readonly": True},
        "policy": {"readonly": True},
        "scheduled_purge_date": {"readonly": True},
        "deleted_date": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "kid": {"key": "kid", "type": "str"},
        "sid": {"key": "sid", "type": "str"},
        "x509_thumbprint": {"key": "x5t", "type": "base64"},
        "policy": {"key": "policy", "type": "CertificatePolicy"},
        "cer": {"key": "cer", "type": "bytearray"},
        "content_type": {"key": "contentType", "type": "str"},
        "attributes": {"key": "attributes", "type": "CertificateAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
        "recovery_id": {"key": "recoveryId", "type": "str"},
        "scheduled_purge_date": {"key": "scheduledPurgeDate", "type": "unix-time"},
        "deleted_date": {"key": "deletedDate", "type": "unix-time"},
    }

    def __init__(
        self,
        *,
        cer: Optional[bytes] = None,
        content_type: Optional[str] = None,
        attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        recovery_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cer: CER contents of x509 certificate.
        :paramtype cer: bytes
        :keyword content_type: The content type of the secret.
        :paramtype content_type: str
        :keyword attributes: The certificate attributes.
        :paramtype attributes: ~azure.keyvault.v7_1.models.CertificateAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        :keyword recovery_id: The url of the recovery object, used to identify and recover the deleted
         certificate.
        :paramtype recovery_id: str
        """
        super().__init__(cer=cer, content_type=content_type, attributes=attributes, tags=tags, **kwargs)
        self.recovery_id = recovery_id
        self.scheduled_purge_date = None
        self.deleted_date = None


class DeletedCertificateItem(CertificateItem):
    """The deleted certificate item containing metadata about the deleted certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Certificate identifier.
    :vartype id: str
    :ivar attributes: The certificate management attributes.
    :vartype attributes: ~azure.keyvault.v7_1.models.CertificateAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    :ivar x509_thumbprint: Thumbprint of the certificate.
    :vartype x509_thumbprint: bytes
    :ivar recovery_id: The url of the recovery object, used to identify and recover the deleted
     certificate.
    :vartype recovery_id: str
    :ivar scheduled_purge_date: The time when the certificate is scheduled to be purged, in UTC.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar deleted_date: The time when the certificate was deleted, in UTC.
    :vartype deleted_date: ~datetime.datetime
    """

    _validation = {
        "scheduled_purge_date": {"readonly": True},
        "deleted_date": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "attributes": {"key": "attributes", "type": "CertificateAttributes"},
        "tags": {"key": "tags", "type": "{str}"},
        "x509_thumbprint": {"key": "x5t", "type": "base64"},
        "recovery_id": {"key": "recoveryId", "type": "str"},
        "scheduled_purge_date": {"key": "scheduledPurgeDate", "type": "unix-time"},
        "deleted_date": {"key": "deletedDate", "type": "unix-time"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        attributes: Optional["_models.CertificateAttributes"] = None,
        tags: Optional[Dict[str, str]] = None,
        x509_thumbprint: Optional[bytes] = None,
        recovery_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Certificate identifier.
        :paramtype id: str
        :keyword attributes: The certificate management attributes.
        :paramtype attributes: ~azure.keyvault.v7_1.models.CertificateAttributes
        :keyword tags: Application specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        :keyword x509_thumbprint: Thumbprint of the certificate.
        :paramtype x509_thumbprint: bytes
        :keyword recovery_id: The url of the recovery object, used to identify and recover the deleted
         certificate.
        :paramtype recovery_id: str
        """
        super().__init__(id=id, attributes=attributes, tags=tags, x509_thumbprint=x509_thumbprint, **kwargs)
        self.recovery_id = recovery_id
        self.scheduled_purge_date = None
        self.deleted_date = None


class DeletedCertificateListResult(_serialization.Model):
    """A list of certificates that have been deleted in this vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A response message containing a list of deleted certificates in the vault along
     with a link to the next page of deleted certificates.
    :vartype value: list[~azure.keyvault.v7_1.models.DeletedCertificateItem]
    :ivar next_link: The URL to get the next set of deleted certificates.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DeletedCertificateItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class Error(_serialization.Model):
    """The key vault server error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar inner_error: The key vault server error.
    :vartype inner_error: ~azure.keyvault.v7_1.models.Error
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "inner_error": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "inner_error": {"key": "innererror", "type": "Error"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.inner_error = None


class IssuerAttributes(_serialization.Model):
    """The attributes of an issuer managed by the Key Vault service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar enabled: Determines whether the issuer is enabled.
    :vartype enabled: bool
    :ivar created: Creation time in UTC.
    :vartype created: ~datetime.datetime
    :ivar updated: Last updated time in UTC.
    :vartype updated: ~datetime.datetime
    """

    _validation = {
        "created": {"readonly": True},
        "updated": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "created": {"key": "created", "type": "unix-time"},
        "updated": {"key": "updated", "type": "unix-time"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Determines whether the issuer is enabled.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.created = None
        self.updated = None


class IssuerBundle(_serialization.Model):
    """The issuer for Key Vault certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Identifier for the issuer object.
    :vartype id: str
    :ivar provider: The issuer provider.
    :vartype provider: str
    :ivar credentials: The credentials to be used for the issuer.
    :vartype credentials: ~azure.keyvault.v7_1.models.IssuerCredentials
    :ivar organization_details: Details of the organization as provided to the issuer.
    :vartype organization_details: ~azure.keyvault.v7_1.models.OrganizationDetails
    :ivar attributes: Attributes of the issuer object.
    :vartype attributes: ~azure.keyvault.v7_1.models.IssuerAttributes
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "provider": {"key": "provider", "type": "str"},
        "credentials": {"key": "credentials", "type": "IssuerCredentials"},
        "organization_details": {"key": "org_details", "type": "OrganizationDetails"},
        "attributes": {"key": "attributes", "type": "IssuerAttributes"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        credentials: Optional["_models.IssuerCredentials"] = None,
        organization_details: Optional["_models.OrganizationDetails"] = None,
        attributes: Optional["_models.IssuerAttributes"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: The issuer provider.
        :paramtype provider: str
        :keyword credentials: The credentials to be used for the issuer.
        :paramtype credentials: ~azure.keyvault.v7_1.models.IssuerCredentials
        :keyword organization_details: Details of the organization as provided to the issuer.
        :paramtype organization_details: ~azure.keyvault.v7_1.models.OrganizationDetails
        :keyword attributes: Attributes of the issuer object.
        :paramtype attributes: ~azure.keyvault.v7_1.models.IssuerAttributes
        """
        super().__init__(**kwargs)
        self.id = None
        self.provider = provider
        self.credentials = credentials
        self.organization_details = organization_details
        self.attributes = attributes


class IssuerCredentials(_serialization.Model):
    """The credentials to be used for the certificate issuer.

    :ivar account_id: The user name/account name/account id.
    :vartype account_id: str
    :ivar password: The password/secret/account key.
    :vartype password: str
    """

    _attribute_map = {
        "account_id": {"key": "account_id", "type": "str"},
        "password": {"key": "pwd", "type": "str"},
    }

    def __init__(self, *, account_id: Optional[str] = None, password: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword account_id: The user name/account name/account id.
        :paramtype account_id: str
        :keyword password: The password/secret/account key.
        :paramtype password: str
        """
        super().__init__(**kwargs)
        self.account_id = account_id
        self.password = password


class IssuerParameters(_serialization.Model):
    """Parameters for the issuer of the X509 component of a certificate.

    :ivar name: Name of the referenced issuer object or reserved names; for example, 'Self' or
     'Unknown'.
    :vartype name: str
    :ivar certificate_type: Certificate type as supported by the provider (optional); for example
     'OV-SSL', 'EV-SSL'.
    :vartype certificate_type: str
    :ivar certificate_transparency: Indicates if the certificates generated under this policy
     should be published to certificate transparency logs.
    :vartype certificate_transparency: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "certificate_type": {"key": "cty", "type": "str"},
        "certificate_transparency": {"key": "cert_transparency", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        certificate_type: Optional[str] = None,
        certificate_transparency: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the referenced issuer object or reserved names; for example, 'Self' or
         'Unknown'.
        :paramtype name: str
        :keyword certificate_type: Certificate type as supported by the provider (optional); for
         example 'OV-SSL', 'EV-SSL'.
        :paramtype certificate_type: str
        :keyword certificate_transparency: Indicates if the certificates generated under this policy
         should be published to certificate transparency logs.
        :paramtype certificate_transparency: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.certificate_type = certificate_type
        self.certificate_transparency = certificate_transparency


class KeyProperties(_serialization.Model):
    """Properties of the key pair backing a certificate.

    :ivar exportable: Not supported in this version. Indicates if the private key can be exported.
    :vartype exportable: bool
    :ivar key_type: The type of key pair to be used for the certificate. Known values are: "EC",
     "EC-HSM", "RSA", "RSA-HSM", and "oct".
    :vartype key_type: str or ~azure.keyvault.v7_1.models.JsonWebKeyType
    :ivar key_size: The key size in bits. For example: 2048, 3072, or 4096 for RSA.
    :vartype key_size: int
    :ivar reuse_key: Indicates if the same key pair will be used on certificate renewal.
    :vartype reuse_key: bool
    :ivar curve: Elliptic curve name. For valid values, see JsonWebKeyCurveName. Known values are:
     "P-256", "P-384", "P-521", and "P-256K".
    :vartype curve: str or ~azure.keyvault.v7_1.models.JsonWebKeyCurveName
    """

    _attribute_map = {
        "exportable": {"key": "exportable", "type": "bool"},
        "key_type": {"key": "kty", "type": "str"},
        "key_size": {"key": "key_size", "type": "int"},
        "reuse_key": {"key": "reuse_key", "type": "bool"},
        "curve": {"key": "crv", "type": "str"},
    }

    def __init__(
        self,
        *,
        exportable: Optional[bool] = None,
        key_type: Optional[Union[str, "_models.JsonWebKeyType"]] = None,
        key_size: Optional[int] = None,
        reuse_key: Optional[bool] = None,
        curve: Optional[Union[str, "_models.JsonWebKeyCurveName"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword exportable: Not supported in this version. Indicates if the private key can be
         exported.
        :paramtype exportable: bool
        :keyword key_type: The type of key pair to be used for the certificate. Known values are: "EC",
         "EC-HSM", "RSA", "RSA-HSM", and "oct".
        :paramtype key_type: str or ~azure.keyvault.v7_1.models.JsonWebKeyType
        :keyword key_size: The key size in bits. For example: 2048, 3072, or 4096 for RSA.
        :paramtype key_size: int
        :keyword reuse_key: Indicates if the same key pair will be used on certificate renewal.
        :paramtype reuse_key: bool
        :keyword curve: Elliptic curve name. For valid values, see JsonWebKeyCurveName. Known values
         are: "P-256", "P-384", "P-521", and "P-256K".
        :paramtype curve: str or ~azure.keyvault.v7_1.models.JsonWebKeyCurveName
        """
        super().__init__(**kwargs)
        self.exportable = exportable
        self.key_type = key_type
        self.key_size = key_size
        self.reuse_key = reuse_key
        self.curve = curve


class KeyVaultError(_serialization.Model):
    """The key vault error exception.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: The key vault server error.
    :vartype error: ~azure.keyvault.v7_1.models.Error
    """

    _validation = {
        "error": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error = None


class LifetimeAction(_serialization.Model):
    """Action and its trigger that will be performed by Key Vault over the lifetime of a certificate.

    :ivar trigger: The condition that will execute the action.
    :vartype trigger: ~azure.keyvault.v7_1.models.Trigger
    :ivar action: The action that will be executed.
    :vartype action: ~azure.keyvault.v7_1.models.Action
    """

    _attribute_map = {
        "trigger": {"key": "trigger", "type": "Trigger"},
        "action": {"key": "action", "type": "Action"},
    }

    def __init__(
        self, *, trigger: Optional["_models.Trigger"] = None, action: Optional["_models.Action"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword trigger: The condition that will execute the action.
        :paramtype trigger: ~azure.keyvault.v7_1.models.Trigger
        :keyword action: The action that will be executed.
        :paramtype action: ~azure.keyvault.v7_1.models.Action
        """
        super().__init__(**kwargs)
        self.trigger = trigger
        self.action = action


class OrganizationDetails(_serialization.Model):
    """Details of the organization of the certificate issuer.

    :ivar id: Id of the organization.
    :vartype id: str
    :ivar admin_details: Details of the organization administrator.
    :vartype admin_details: list[~azure.keyvault.v7_1.models.AdministratorDetails]
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "admin_details": {"key": "admin_details", "type": "[AdministratorDetails]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        admin_details: Optional[List["_models.AdministratorDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Id of the organization.
        :paramtype id: str
        :keyword admin_details: Details of the organization administrator.
        :paramtype admin_details: list[~azure.keyvault.v7_1.models.AdministratorDetails]
        """
        super().__init__(**kwargs)
        self.id = id
        self.admin_details = admin_details


class PendingCertificateSigningRequestResult(_serialization.Model):
    """The pending certificate signing request result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The pending certificate signing request as Base64 encoded string.
    :vartype value: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class SecretProperties(_serialization.Model):
    """Properties of the key backing a certificate.

    :ivar content_type: The media type (MIME type).
    :vartype content_type: str
    """

    _attribute_map = {
        "content_type": {"key": "contentType", "type": "str"},
    }

    def __init__(self, *, content_type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword content_type: The media type (MIME type).
        :paramtype content_type: str
        """
        super().__init__(**kwargs)
        self.content_type = content_type


class SubjectAlternativeNames(_serialization.Model):
    """The subject alternate names of a X509 object.

    :ivar emails: Email addresses.
    :vartype emails: list[str]
    :ivar dns_names: Domain names.
    :vartype dns_names: list[str]
    :ivar upns: User principal names.
    :vartype upns: list[str]
    """

    _attribute_map = {
        "emails": {"key": "emails", "type": "[str]"},
        "dns_names": {"key": "dns_names", "type": "[str]"},
        "upns": {"key": "upns", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        emails: Optional[List[str]] = None,
        dns_names: Optional[List[str]] = None,
        upns: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword emails: Email addresses.
        :paramtype emails: list[str]
        :keyword dns_names: Domain names.
        :paramtype dns_names: list[str]
        :keyword upns: User principal names.
        :paramtype upns: list[str]
        """
        super().__init__(**kwargs)
        self.emails = emails
        self.dns_names = dns_names
        self.upns = upns


class Trigger(_serialization.Model):
    """A condition to be satisfied for an action to be executed.

    :ivar lifetime_percentage: Percentage of lifetime at which to trigger. Value should be between
     1 and 99.
    :vartype lifetime_percentage: int
    :ivar days_before_expiry: Days before expiry to attempt renewal. Value should be between 1 and
     validity_in_months multiplied by 27. If validity_in_months is 36, then value should be between
     1 and 972 (36 * 27).
    :vartype days_before_expiry: int
    """

    _validation = {
        "lifetime_percentage": {"maximum": 99, "minimum": 1},
    }

    _attribute_map = {
        "lifetime_percentage": {"key": "lifetime_percentage", "type": "int"},
        "days_before_expiry": {"key": "days_before_expiry", "type": "int"},
    }

    def __init__(
        self, *, lifetime_percentage: Optional[int] = None, days_before_expiry: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword lifetime_percentage: Percentage of lifetime at which to trigger. Value should be
         between 1 and 99.
        :paramtype lifetime_percentage: int
        :keyword days_before_expiry: Days before expiry to attempt renewal. Value should be between 1
         and validity_in_months multiplied by 27. If validity_in_months is 36, then value should be
         between 1 and 972 (36 * 27).
        :paramtype days_before_expiry: int
        """
        super().__init__(**kwargs)
        self.lifetime_percentage = lifetime_percentage
        self.days_before_expiry = days_before_expiry


class X509CertificateProperties(_serialization.Model):
    """Properties of the X509 component of a certificate.

    :ivar subject: The subject name. Should be a valid X509 distinguished Name.
    :vartype subject: str
    :ivar ekus: The enhanced key usage.
    :vartype ekus: list[str]
    :ivar subject_alternative_names: The subject alternative names.
    :vartype subject_alternative_names: ~azure.keyvault.v7_1.models.SubjectAlternativeNames
    :ivar key_usage: List of key usages.
    :vartype key_usage: list[str or ~azure.keyvault.v7_1.models.KeyUsageType]
    :ivar validity_in_months: The duration that the certificate is valid in months.
    :vartype validity_in_months: int
    """

    _validation = {
        "validity_in_months": {"minimum": 0},
    }

    _attribute_map = {
        "subject": {"key": "subject", "type": "str"},
        "ekus": {"key": "ekus", "type": "[str]"},
        "subject_alternative_names": {"key": "sans", "type": "SubjectAlternativeNames"},
        "key_usage": {"key": "key_usage", "type": "[str]"},
        "validity_in_months": {"key": "validity_months", "type": "int"},
    }

    def __init__(
        self,
        *,
        subject: Optional[str] = None,
        ekus: Optional[List[str]] = None,
        subject_alternative_names: Optional["_models.SubjectAlternativeNames"] = None,
        key_usage: Optional[List[Union[str, "_models.KeyUsageType"]]] = None,
        validity_in_months: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword subject: The subject name. Should be a valid X509 distinguished Name.
        :paramtype subject: str
        :keyword ekus: The enhanced key usage.
        :paramtype ekus: list[str]
        :keyword subject_alternative_names: The subject alternative names.
        :paramtype subject_alternative_names: ~azure.keyvault.v7_1.models.SubjectAlternativeNames
        :keyword key_usage: List of key usages.
        :paramtype key_usage: list[str or ~azure.keyvault.v7_1.models.KeyUsageType]
        :keyword validity_in_months: The duration that the certificate is valid in months.
        :paramtype validity_in_months: int
        """
        super().__init__(**kwargs)
        self.subject = subject
        self.ekus = ekus
        self.subject_alternative_names = subject_alternative_names
        self.key_usage = key_usage
        self.validity_in_months = validity_in_months
